<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pendaftaran Berhasil - Klinik Kecantikan</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
            border-radius: 10px 10px 0 0;
        }
        .content {
            background: #f8f9fa;
            padding: 30px;
            border-radius: 0 0 10px 10px;
        }
        .info-box {
            background: #e3f2fd;
            border: 1px solid #2196f3;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        .credentials-box {
            background: #f3e5f5;
            border: 1px solid #9c27b0;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        .button {
            display: inline-block;
            background: #4caf50;
            color: white;
            padding: 12px 24px;
            text-decoration: none;
            border-radius: 5px;
            margin: 10px 0;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            color: #666;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>🏥 Klinik Kecantikan</h1>
        <h2>Pendaftaran Berhasil!</h2>
    </div>

    <div class="content">
        <p>Halo <strong>{{ $patient->name }}</strong>,</p>
        
        <p>Terima kasih telah mendaftar di Klinik Kecantikan. Pendaftaran Anda telah berhasil diproses.</p>

        <div class="info-box">
            <h3>📋 Detail Pendaftaran</h3>
            <p><strong>No. Registrasi:</strong> {{ $registration->registration_number }}</p>
            <p><strong>Tanggal Pemeriksaan:</strong> {{ $registration->exam_date->format('d F Y') }}</p>
            <p><strong>Jenis Pemeriksaan:</strong> {{ ucfirst($registration->exam_type) }}</p>
            @if($registration->notes)
                <p><strong>Catatan:</strong> {{ $registration->notes }}</p>
            @endif
        </div>

        <div class="credentials-box">
            <h3>🔐 Kredensial Portal Pasien</h3>
            <p><strong>No. Rekam Medis (MRN):</strong> <code style="background: #fff; padding: 4px 8px; border-radius: 4px;">{{ $patient->mrn }}</code></p>
            <p><strong>Password:</strong> <code style="background: #fff; padding: 4px 8px; border-radius: 4px;">{{ $password }}</code></p>
            
            <div style="background: #fff3cd; border: 1px solid #ffeaa7; border-radius: 4px; padding: 10px; margin: 10px 0;">
                <strong>⚠️ Penting:</strong> Simpan informasi login ini dengan baik. Anda akan membutuhkannya untuk mengakses hasil pemeriksaan.
            </div>
        </div>

        <div style="text-align: center; margin: 30px 0;">
            <a href="{{ route('results.patient.form') }}" class="button">
                🏥 Akses Portal Pasien
            </a>
        </div>

        <div style="background: #e8f5e8; border: 1px solid #4caf50; border-radius: 8px; padding: 15px; margin: 20px 0;">
            <h3>📝 Langkah Selanjutnya:</h3>
            <ol>
                <li>Lakukan pembayaran sesuai instruksi yang diberikan</li>
                <li>Datang pada tanggal yang telah ditentukan</li>
                <li>Setelah pemeriksaan, hasil akan tersedia di Portal Pasien</li>
                <li>Gunakan MRN dan password di atas untuk mengakses hasil</li>
            </ol>
        </div>

        <p>Jika Anda memiliki pertanyaan, silakan hubungi kami di:</p>
        <ul>
            <li>📞 Telepon: (021) 1234-5678</li>
            <li>📧 Email: info@klinikkecantikan.com</li>
            <li>🌐 Website: www.klinikkecantikan.com</li>
        </ul>
    </div>

    <div class="footer">
        <p>© {{ date('Y') }} Klinik Kecantikan. Semua hak dilindungi.</p>
        <p>Email ini dikirim secara otomatis, harap tidak membalas email ini.</p>
    </div>
</body>
</html>
